function [rms_errors, cdx_new, rms_5yr_cds] = mispricing_CDX_y0(y0, CDX, discounts_IMM, N, start_date_num, end_date_num, maturities_cds, ...
                                                                maturities_tranches, RMSE_method, LGD_method, method5, method2, CDX2)
% --------------------------------------------------------------------------------------------------
% Wrapper function that calculates the RMSE pricing error for a credit index structure. The first
% argument overwrites the initial default intensity of the systematic factor in order to be able
% to apply Newton-Raphson to this function.
% --------------------------------------------------------------------------------------------------
% y0                            ... initial default intensity of common factor
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% discounts_IMM                 ... structure with discount curves matching IMM dates
% N                             ... number of points for numerical integration of Fourier transform
% start_date_num                ... datenum of start date
% end_date_num                  ... datenum of end date
% maturities_cds                ... which maturities to fit for CDS prices
% maturities_tranches           ... which maturities to fit for tranche prices
% LGD_method                    ... method for (joint) distribution of LGDs
% method5                       ... which definition to use for the 5th parameters
%                                   'mu' = expected jump size \mu (default)
%                                   'mu*L' = jump intensity x jump size
% method2                       ... which definition to use for the 2nd parameter
%                               ... 'thet' = theta_total
%                               ... 'thet*k' = theta_total * k
% CDX2                          ... second CDX structure for robust RMSE calculation (optional)
% --------------------------------------------------------------------------------------------------
% sample call: mispricing_CDX_y0(...)
% --------------------------------------------------------------------------------------------------

if (nargin <= 12)
    CDX2 = [];
end

% Determine relevant date range
start_pos = find(CDX.dates{1} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{1} <= end_date_num, 1, 'last');
used_range = start_pos:end_pos;
used_dates = CDX.dates{1}(used_range);

% Overwrite value of y0 in credit index structure
CDX.y0(used_range) = y0;

% Update model-implied tranche prices
[trash, cdx_new] = wrapper_tranche_mispricing(get_x0(CDX, used_dates, method5, method2), CDX, discounts_IMM, start_date_num, end_date_num, N, ...
                                              maturities_cds, maturities_tranches, RMSE_method, LGD_method, 2, method5, method2, CDX2);
        
% Calculate RMSE tranche-pricing error
[rms_errors, cdx_new] = RMSE_tranche_mispricing2(cdx_new, start_date_num, end_date_num, maturities_tranches, RMSE_method, 0, CDX2);

% Penalize mispricings at 5-year horizon for CDS
start_pos = find(CDX.dates{1} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{1} <= end_date_num, 1, 'last');
used_range = start_pos:end_pos;

% Extract time series of pricing errors
rms_errors = cdx_new.rmse(used_range);
rms_5yr_cds = cdx_new.rmse_5yr_cds(used_range);